-- Replace message data files.
local whiteData = chaudloader.exedat.open("exe3.dat")
local blueData = chaudloader.exedat.open("exe3b.dat")

local whiteMap = chaudloader.modfiles.read_file("message_engW.map")
local blueMap = chaudloader.modfiles.read_file("message_engB.map")
local whiteMpak = chaudloader.modfiles.read_file("message_engW.mpak")
local blueMpak = chaudloader.modfiles.read_file("message_engB.mpak")

whiteData:write_file("exe3/data/msg/message_eng.map", whiteMap)
whiteData:write_file("exe3/data/msg/message_eng.mpak", whiteMpak)

blueData:write_file("exe3b/data/msg/message_eng.map", blueMap)
blueData:write_file("exe3b/data/msg/message_eng.mpak", blueMpak)

-- Modify Blue (Japanese) ROM data to edit Beach Street graphical assets.
function addToByte(buffer, address, amount)
	amount = amount or 1
	local byte = buffer:get_u8(address)
	buffer:set_u8(address, byte + amount)
end

function setByteString(buffer, address, str)
	local newBuffer = chaudloader.buffer.new_builder()
	for byte in str:gmatch("%S+") do
		newBuffer:write_u8(tonumber(byte, 16))
	end
	buffer:set(address, newBuffer:build())
end

local blueRom = blueData:read_file("exe3b/rom_b.srl")

addToByte(blueRom, 0x4BA3C5, -0x80)
addToByte(blueRom, 0x4BA480)
addToByte(blueRom, 0x4BA4C3)
addToByte(blueRom, 0x4BA5D0)
addToByte(blueRom, 0x4BA642)
addToByte(blueRom, 0x4BA6C6)
addToByte(blueRom, 0x4BA857)
addToByte(blueRom, 0x4BA86D)
addToByte(blueRom, 0x4BA8EE)
addToByte(blueRom, 0x4BA9B4)
addToByte(blueRom, 0x4BA9C5)
addToByte(blueRom, 0x4BA9F3)
addToByte(blueRom, 0x4BA9F8, 0x25)
addToByte(blueRom, 0x4BAA30)
addToByte(blueRom, 0x4BAA67)
addToByte(blueRom, 0x4BAAF5)
addToByte(blueRom, 0x4BAB21)
addToByte(blueRom, 0x4BAB61)
addToByte(blueRom, 0x4BABBB)
addToByte(blueRom, 0x4BAD41)
addToByte(blueRom, 0x4BAE80)
addToByte(blueRom, 0x4BAE85)
addToByte(blueRom, 0x4BAE96, 0x02)

local editedBytes = "1E 40 07 02 27 60 0B 5A C1 13 43 E1 13 47 07 09 C1 06 1E EE 00 CC 1E E1 EE CC E1 11 E1 06 CC E1 1E 1C CC 00 15 F3 9F FF A3 17 34 E1 00 04 11 EE 1E 00 C4 31 EF FF F0 01 43 1F F6 92 27 CB 59 39 D0 0F E7 CB 02 D2 9C 1A E5 33 44 38 34 19 B2 80 02 33 1B F7 02 FA 03 10 63 2F 03 0C BB 33 11 2C 4A 03 30 FF 23 38 20 23 90 03 50 2F 93 2F 63 55 10 36 23 67 78 BB F3 5F 83 9E 10 46 03 3F 44 77 75 AB 13 4F 24 00 8F 24 00 91 24 70 9F 03 5F 8D 03 7F 44 43 32 19 12 90 1F 34 04 0C 01 31 33 88 88 11 33 43 03 7F 5E 43 03 7F 43 F3 7F 63 7F D0 01 23 5F 99 3D 22 22 05 F9 23 1F C0 03 10 3D 33 00 44 FB 28 13 D3 1F D9 AF 13 03 B0 03 33 00 03 35 3D CF 13 AE 03 20 AB FF 00 04 01 F2 10 03 60 01 B5 02 14 FF 12 19 13 03 1B 01 30 1A 00 03 1E AA 11 F1 15 90 02 4E 1D 2D 3D 2E F1 00 11 19 91 F1 1F 99 11 FF 01 EE 99 1E EF EE 9E 19 0D 9F 02 19 1E 11 EE 11 1E 34 12 2F 55 A9 03 03 99 43 0B A1 80 03 12 00 03 4C 1E 23 1F BE BE 42 EF 02 AF BA BE 06 BB AB BA BB EB 03 99 02 FB AA 09 BB BE AB AA 00 02 AA BE 19 85 9D 00 1C AB EB 00 09 00 07 45 EE EE 25 EE 82 36 8A BE EE BE BA EB 00 33 EB D1 09 94 00 25 BA 10 03 BE EE AB 13 45 2A FF E1 43 0B CE 80 03 C1 40 03 11 20 CC EC 03 0F E1 1E 11 CC 1C 30 E1 11 03 0F 00 03 EE 11 CC CC 20 1E F1 00 0B 31 EE CC 11 4F 14 11 E1 1E 00 1D EE 00 CA E1 7E 00 11 44 16 EE 41 44 64 63 01 BB 4B 34 3B BB BB 4B 00 76 60 B4 26 FF 53 2F 71 EE EE FF 1E 80 00 04 16 11 7E EE 63 71 E1 04 7E 6B 26 76 E1 43 5F 42 FF 28 FF 2F 60 03 EE 10 03 EE 2F 42 60 7E 00 03 11 C2 33 33 5B 77 33 00 BB 5B 77 BB BB 5A 77 BB 3E AA 5A 04 AF 70 03 FC BF DC C4 03 3F 66 95 01 FC 66 99 10 03 88 80 03 98 00 03 7A 89 12 E3 12 FC 26 7B 02 D5 98 00 04 89 80 00 04 88 99 89 55 98 99 88 76 88 F6 9A 63 3A 1A 2C 55 F6 5F 76 5F 46 E7 F2 FF 12 FF 03 CF BB AA 00 02 25 61 00 1F 03 BB 43 32 BB AA 43 10 0F 15 88 80 C0 01 BB 88 18 41 AA 8B 88 1C 11 AA BA F0 03 10 03 F4 FA BB 99 BD 00 02 99 00 02 20 01 D0 0F 40 01 AA 00 02 EA 39 48 C0 0F 00 01 9A 00 02 99 00 02 A9 ED 00 02 04 DD 3C EF AA 00 04 00 8D 22 00 12 BF 00 4A A9 00 22 30 03 FD 1F B0 2F 11 DE 93 4F E2 D8 AB D3 4F D0 2F FF 11 F1 02 39 21 77 55 00 1E 10 03 E3 7F EE 03 23 19 C3 10 03 7D 65 00 03 03 A5 29 3E 40 03 03 9F BB 03 1A FF 26 47 F6 4C 02 FE 10 F0 01 86 03 36 00 20 03 9C 8F F6 6C EB BB BA 13 26 00 19 F0 1C 29 C1 F0 16 4B 93 33 10 03 56 5F CE E1 C1 21 01 B3 CC 1C B3 BB 1C CC 00 03 00 11 B2 BB EC 21 BB BB CC 00 31 BB BB C1 CC BB BB 1C E8 00 07 F0 01 10 01 4B 03 42 33 43 3B 00 33 66 66 4B 36 63 71 4B 01 B3 4B 63 BB B3 BB 24 00 18 50 64 00 03 13 00 03 14 43 B4 BB 05 24 66 66 44 24 13 27 71 00 03 7D E1 C0 03 10 17 10 03 93 2B 70 03 5B 30 03 4F BA 10 07 44 44 00 FE 10 03 62 72 50 02 5A 55 00 0C 55 0C 12 0E B5 11 1E BF BB FC 03 4F D0 2F DE DF 83 8E 25 6E D8 8F 44 44 18 22 42 44 85 CB 05 F6 E7 44 54 50 76 09 7E 66 00 03 65 76 44 55 15 65 76 52 03 A9 22 03 3B 22 00 04 00 DE 7D 57 55 EE DD 57 55 02 E7 DE 5D 55 77 EE 00 03 E7 63 5E 05 CF 10 03 57 55 33 10 03 73 CB 50 99 40 03 89 93 E7 99 89 88 88 B7 03 C6 88 00 06 00 01 11 10 03 00 04 80 03 BD 03 C5 88 00 04 00 18 10 03 E0 25 47 03 BF 45 47 03 BF 47 66 24 06 57 24 06 4F 60 24 D3 DF 03 BF AB BA 43 B3 AA 2E BB 44 00 03 33 05 9F 10 03 00 0A AB FF 10 03 5B 7F 12 63 10 03 00 01 03 38 20 03 50 01 9F 00 0B A9 A9 40 02 40 18 13 89 00 09 10 06 DE F3 F3 30 03 BB 30 03 F3 BF 50 01 03 9C 9A EF 10 15 50 0E 20 24 99 03 D9 13 DD 13 DE 13 FC FF 30 07 00 04 20 2C 10 0E 30 0F 10 83 33 E0 00 06 FF 64 2B 30 2A 50 04 82 2F F0 01 50 01 5E FF 54 0F DE D0 2F 06 E1 BE 3C E9 33 AF E7 5F AD 75 BE FF 2D 40 90 2F 53 D8 07 25 00 03 17 24 19 F9 10 03 F8 10 11 26 DF 93 97 20 03 00 45 11 EE BE A1 30 03 1C 03 87 EC CC B4 4B 03 A3 60 4B 03 A3 00 03 B4 3B 11 CC B6 08 34 11 11 46 00 03 BF 3B 33 11 63 66 56 03 86 56 43 33 00 07 03 43 34 66 B3 4B 34 18 5A 0E CE 20 33 16 10 03 11 11 32 63 11 10 11 31 12 00 03 13 26 11 31 00 1F 33 16 2F E1 4B 12 EF 00 E7 66 11 E2 EE 61 11 E1 6A E7 53 87 50 03 E7 10 07 E7 70 07 ED 75 ED F0 01 90 01 FA 3F 33 16 3F BB 00 02 35 AA B7 00 03 00 0F 75 00 0F 75 00 0F 56 75 00 0E 75 01 5C 75 01 56 70 03 BA C0 03 EF 07 37 AA AB 5A 77 BA AB 15 5B 77 BA 03 F7 BB 03 F7 AB 10 03 FF 07 53 13 CD 03 94 10 03 F7 3F 23 EF 70 01 23 F8 FE C0 2F 93 EF 04 0A 1A A9 39 58 40 01 00 12 43 F0 90 0F 80 01 10 29 00 03 57 55 32 33 09 53 55 22 32 00 03 22 52 E0 03 0A 33 66 69 96 00 03 76 00 03 72 DB 40 07 A0 03 89 03 A5 F0 03 88 10 03 23 F3 A6 33 C7 82 00 03 22 82 5D 7D 50 03 28 DF 00 03 03 AA AA 20 03 07 8C 10 03 01 43 07 2F 73 9A 03 B9 30 03 37 0F AA A9 00 04 03 08 0C 9A 99 9A 9A 00 0B 10 03 A9 99 FF 23 AB 00 0A 23 1F 20 29 13 16 03 B1 40 03 23 FA 6D BA 03 A3 10 03 BB 17 AB 00 03 AB 40 03 87 13 BB BB 88 88 21 01 B7 21 CF 17 36 B7 17 40 55 00 04 01 33 22 51 7F D6 19 00 2A 1F 99 33 33 0A F8 00 04 10 2F F3 FF 87 C3 FF 40 90 87 D3 20 25 57 BE 74 16 28 07 30 0C 33 FC FF 63 DC D0 13 38 33 50 16 30 F4 00 3B 00 03 94 D2 FF 83 FF C8 0F D3 FF F8 3F 40 2F 4B DF D3 EF D4 1F 7C BE 03 C3 04 41 1D D3 10 03 00 2F FF EB 80 97 FF 11 11 B2 34 11 21 B3 00 34 21 44 BB 34 43 44 33 00 34 43 BB 33 4B EB 3B 33 00 4B BB E3 B3 3B BB 33 EB 04 3B 66 36 33 15 00 03 16 66 00 36 63 15 63 33 63 15 33 08 44 34 66 34 03 EC 34 33 63 00 16 43 34 63 26 11 1E EE 2D EE 11 08 17 E1 00 07 10 08 E1 0A ED 04 11 21 FF 2F 21 20 85 22 22 D5 53 C7 13 DB CC 10 03 1E 00 03 11 00 03 5A 13 00 03 22 0A CF 03 C3 EE 00 04 DD B6 00 04 DD 00 04 0D D2 EE 9D DF D3 EF 11 F0 10 03 00 04 08 FB 10 03 11 B7 BA AB 7F AA 20 03 01 35 20 03 06 44 20 03 01 3B 10 03 D1 A3 EB 60 03 BA 40 03 BB 75 AA 03 E3 78 BA 20 03 0B 3B 10 03 04 07 BB AB 66 3A 77 BB 0D 28 1D 2F C3 BF 43 07 CA 34 02 55 22 44 34 34 44 00 04 33 CC 00 04 C3 CF 43 43 0D BD 01 20 44 43 F1 27 DF 90 1A 33 CF 1B 14 55 BB AA 00 02 F3 21 E8 D0 0F D0 01 33 C7 99 79 47 C3 9B 9F F7 20 03 53 C7 37 BF F0 01 28 08 43 50 03 10 0C C4 10 11 07 F1 29 88 98 07 F9 99 99 5E 88 00 73 99 97 7F D0 03 F0 01 28 FC 88 AF 00 02 88 00 02 32 2D 43 07 70 40 0F 00 5B EE 00 63 02 9F 12 A7 23 07 FF 20 0F 02 B9 22 3F 22 24 00 05 FE FF FC 9F 25 24 1E 83 23 EE EF 63 EF F9 3F 20 2F 33 23 23 03 47 00 04 F4 1F FF 05 9F 17 8B 33 D7 23 FE D0 2F 27 D6 24 21 43 D3 7F 9A 00 01 37 E9 23 B0 10 04 57 DB 20 03 C8 9C FF F0 01 10 22 38 4B 30 56 B0 0F FC 5F F4 9F A7 FF 3C 33 B3 03 AF 10 03 F3 DF 13 DF 33 34 03 33 F4 E4 44 44 FF 00 03 00 F3 00 44 34 FF 44 44 41 FF FF 28 44 B1 00 1E B2 20 28 2F 22 22 80 03 86 22 32 22 22 CC 33 22 00 32 CC 23 22 33 CC 24 32 86 00 03 33 33 CC 23 00 03 13 83 22 A0 40 03 33 00 03 5C 6C 2F 42 6C 0B 5C 2F 42 C5 00 03 C6 00 0B 43 5F 06 CC B7 BB CA AC 00 03 03 5B CC 80 30 03 AA AA CA B7 AA CA CC B2 13 4F AC 00 03 00 08 75 CA 13 5B CA 9F 00 07 CC BA 00 0F 33 5F 53 87 F0 03 53 9F 74 AB 07 83 10 03 00 3B BB 00 33 AB BA 4D 75 0F AC 75 BA 00 3B 06 1C 75 D3 5F F7 E3 4F 03 89 03 74 02 2F 34 F3 5F 15 5F 00 0C 5D 5A 00 0C 5A F3 5F 20 01 83 2A 98 00 03 B7 0B 0A 98 03 15 21 93 89 0B 2E 53 26 5B 27 72 98 00 06 00 02 10 2A 89 98 00 06 99 10 21 22 12 08 DB 12 12 21 21 A2 04 F6 22 00 06 12 12 22 10 04 11 24 12 22 00 17 11 11 00 8F 55 33 55 99 10 03 88 10 03 88 00 03 98 00 03 09 89 33 99 98 00 0B 89 88 D7 0F EC 43 4F 10 AD 00 13 BB 01 7D 1F 06 BB 88 4E AB F3 5F 33 33 FF 3F E3 5F F0 1F 24 04 DD 33 33 DD DD 00 02 DD CC 8E 00 03 43 75 77 00 03 00 07 40 0F EE AD C0 04 EE 00 67 DD 00 04 00 0A 22 D5 9B FE 10 20 13 65 01 89 63 AF D0 2F E4 CF C3 7F FF EA 00 A6 F6 BF 72 DF 55 02 87 BB 02 87 BB 55 B4 00 03 4B 06 2F BB 00 03 FF 70 03 B5 9F 2B DD 10 03 C0 04 B7 02 A2 B7 02 98 CE 62 73 02 95 B7 C5 40 07 10 03 30 17 BA A7 40 03 BB 00 03 AB B7 02 90 00 03 00 17 F3 01 7F 02 9B 08 F7 02 9B AA 75 01 95 02 9B 3D AA 76 96 1F 41 D3 50 03 11 DB 99 01 DB EF 01 DF 05 9F 72 34 98 32 42 20 06 12 54 12 62 6D 89 20 06 02 1F 99 00 04 00 0D 55 20 14 34 88 99 02 93 00 03 98 10 03 A9 A9 02 11 22 21 55 55 21 00 03 55 47 11 00 03 55 55 AA 10 03 00 04 02 B9 AB 10 03 88 00 AA BA 20 03 BB 30 01 00 0A E8 20 03 00 0A 10 03 66 F1 FF 24 EE 33 15 33 EE EE 00 02 EE 01 DD EE 00 1F ED 00 03 00 07 40 0F FF C0 04 12 05 EE 00 04 BF 00 0B CC 30 22 60 02 30 03 C2 0F C0 2F 10 0A FF A2 4F D0 2F 40 01 00 17 40 30 00 04 00 2A 10 0F DB 20 2F 02 04 33 10 04 00 8A 22 20 8F 20 54 FB 30 01 10 2F D2 7F D0 2F F2 7F AA AA 1F 52 47 49 33 00 03 22 33 15 07 23 42 0A F6 C8 02 57 10 03 11 42 F4 77 33 77 33 0F 33 5B 77 33 08 33 18 2F E2 5F D4 DF 5F 75 02 3B C5 00 03 20 01 F4 DF FC 1F 74 EF EF 13 E2 F4 FF A4 FF 33 17 A3 04 20 02 BD 60 04 FF F4 E6 40 01 10 1D 02 CF 00 2F 30 2C F0 22 70 01 EF 50 4D C2 D7 00 03 99 50 03 22 E3 22 B1 75 1F 87 F8 87 98 9A AA 88 0F 3E 00 03 00 07 C8 22 B1 40 03 A9 9A 02 DF AA AA 8A 98 10 0D AA 8A AF 99 37 34 9A 89 A9 DA 00 1D 02 EF 88 00 04 00 49 55 00 2A 88 F4 10 03 15 B4 10 37 00 51 88 0E 68 66 55 EA 10 03 00 04 00 2A 66 70 2F 98 00 03 99 05 99 77 AB AA BA 40 03 BB 00 03 3F 66 77 03 BB 23 B8 03 BA 00 02 01 3F 90 12 A8 F0 01 47 03 3F 47 03 3F 47 66 24 08 33 66 77 24 00 33 24 DD 77 19 77 DD DD 00 02 35 3F 32 33 00 03 FF F5 3F 65 3F 20 02 22 DF 42 E7 C3 2F C2 CF E2 FF FF D3 8F 80 2F A0 3C F3 BF F3 BF C0 2F F0 6F F0 9F D4 15 CF 23 4F FE 43 7F EF 00 01 EE EF 00 FE EE FE EF FF CC EE FE 7F FE F3 7F 13 53 15 B9 15 C2 F9 DF 69 DF 49 CC E7 F9 DF B0 01 07 B9 77 AA F0 03 60 03 17 07 0A 44 22 22 43 08 FE 54 00 2E 24 CF 10 52 80 02 44 43 20 6A BD 3F 00 2F 00 8A 7F 22 19 2F 0D 48 36 8F 00 1A AD 6B 50 2F F4 3F FF B0 2F 73 5C 13 76 30 04 F3 4E AB 3C 33 A5 30 09 FF F3 AB 50 1A 40 04 16 43 C6 63 A0 03 F0 01 58 C7 30 88 A8 30 0D 03 25 98 A8 A8 88 15 98 AA A8 03 7F A8 03 52 A8 03 40 21 A8 AA 08 7A 89 88 A9 99 13 63 29 89 98 60 03 9A 30 03 A9 AA 50 03 BF 16 8D A8 13 B1 13 6F F3 DF 10 6A 36 AF 20 03 FF 03 E7 00 68 00 14 00 07 20 35 16 AA B6 AF C3 EF FE F3 BF 73 EF 10 5D 03 A2 45 73 23 B0 10 01 44 EF 1D 95 1D 98 01 F4 44 F3 1F C2 DF 33 81 22 D8 FC F6 9F F0 1F F6 AF F6 DF 40 04 19 45 33 EE 2F CC FF 00 78 CC 0E B7 30 0F 00 02 15 97 FF 62 DF 03 02 40 0F F2 DF 35 F4 F2 FF 50 1A 10 1D 9F A9 2F 32 55 00 26 72 CF A2 7F F2 9F 00 03 D7 01 72 A3 2F 5B 30 03 BA 10 03 00 0F 06 BF FF D0 8F 73 AC 13 D3 F3 2F D3 5F D3 2F D0 2F F0 9F AF 40 9F 34 20 9F 44 96 6B 90 04 F3 0A A3 16 FF 80 15 F0 01 90 3B F3 33 60 03 26 C7 92 C8 29 9B F1 BD A7 00 0F 03 03 06 BF 99 99 9A 09 AE 31 99 A8 30 0B 50 03 9A AA 89 5E 5E EF 06 AF 00 12 40 03 A8 10 03 30 22 10 58 20 59 DA E0 5A 30 5F 88 07 1F 20 03 99 27 0F 99 80 10 03 99 A8 A8 99 89 AA A8 2E 99 88 3E 6A 9A 3E 7B 27 0F 20 03 99 37 AA 89 00 03 10 07 9A D7 0F D3 AF 8A 33 B0 0A F5 AA 12 10 A0 01 55 CC 5C 55 03 55 CC 55 C5 CC CC 2A 5E 20 05 D9 90 2F 3B 59 21 0C CB 0C CF 21 22 00 09 03 21 12 22 22 11 12 10 0E 0C F6 7C 11 79 13 63 9F 27 57 13 B7 10 03 43 34 97 1D 9B 44 34 10 03 43 10 07 0E A3 0D AB BF 12 5D 43 0D B7 17 36 FA 3F 33 9F 1A A5 03 5F FF B3 6F D3 5F 70 0F F3 5F 22 C6 20 CE 7E 0F F0 01 DF F2 36 00 02 BB 05 9A 0B 45 F9 3F E2 CF F2 FF 00 43 BB 22 22 55 AA BB 22 FF 02 DB 19 A5 13 23 00 9F 33 E0 23 BB 13 34 53 38 FF 17 0F 13 D4 53 FF 60 2F 4E DF F3 99 34 17 4A 17 F8 00 35 20 3F 60 0F 13 F3 00 02 AB 55 BA 80 19 E8 BB A9 AA AB 5B 77 BA D6 10 03 03 F3 BB 00 03 AB 0A B7 10 03 BA C0 03 FB 10 03 22 25 33 33 BB 25 F9 07 06 00 B4 00 F7 13 AF 80 F5 99 AA F0 7F E8 17 C6 20 BF 10 6B 9A C0 0F B9 33 55 04 BA BB 55 9A B9 01 29 99 A9 10 BB BA 9A 00 8B 22 33 55 99 20 9A 22 09 D4 B9 AA 9A BA B9 20 9A 9A 01 58 B9 BB AB 76 BA 03 B9 A9 67 C7 CC AA 18 13 18 25 A8 14 36 A9 00 04 BA 00 04 99 A9 99 23 22 A9 02 F4 9B AA A9 10 5F D0 7C BE 60 2F AB 15 14 F4 0A B1 9F 1A AB 0F C8 33 21 55 66 00 03 55 66 33 22 0D 49 D6 01 9F 02 CF 22 02 D8 22 D3 8F 00 2A 99 CE 00 2A 0D 91 66 99 00 2A 00 09 03 D7 89 BF 03 D3 98 10 91 13 8A C0 30 94 0E 20 03 14 2E AD 13 FF 89 04 16 9A D0 2D E0 01 89 00 52 7E 88 13 DD 00 35 00 0E 44 6B 20 03 14 40 CC EF 03 EF 00 4B C0 D4 A9 00 14 44 6B D7 8F D4 6F AF 03 CA 5C 03 00 5C 37 83 23 FF 15 5B 10 03 8F 11 34 BB C5 C5 00 21 10 04 14 07 43 FF 9B 0E 69 CC 11 01 2C 03 DC 55 FB 12 20 01 41 32 00 02 22 77 69 23 22 40 0F 82 0B 3E 32 66 77 33 32 01 5F 23 30 66 22 00 07 0D 47 66 23 22 22 FF 00 13 74 0B F0 03 23 02 A6 43 D0 01 8A 9F F3 FF FF 02 0B 04 22 F3 FF 80 01 30 EB A3 B9 30 0F 13 DC FF 00 02 D3 D2 03 F8 00 1B 20 02 F2 4D B4 23 92 76 FF 60 0F F2 89 F0 01 77 0A A7 BF 30 0F C0 FF EA 94 FF BD FF 9E 1A 30 0F 04 32 44 14 3B 6E 20 0F F1 18 DE 53 4B 01 7C B9 33 51 30 04 40 35 60 04 BB 45 9B 04 04 BB AA A9 00 9C 9B 00 8D 70 AB 00 25 04 13 70 2F AB 99 9B AA 15 AB 99 9A 03 DB 9A 03 29 BA 00 06 20 BA AA 03 DF CB 33 B9 B9 A9 FF 03 CD F0 F6 94 5C 02 ED E0 0F 33 16 20 19 20 1C C0 D0 0F D1 44 55 9B AB 55 AB BB 04 AB AB B9 BA AB 14 31 BA A9 98 00 B0 A9 99 04 39 34 3F 77 B9 BC 00 CC CA 6C 96 9C AA 76 67 00 BA 9C 77 76 6A C8 7B C7 00 6A CC BB 9C AC AB C9 C9 80 00 03 C8 C9 66 97 C9 AA 77 00 9B CC BC 6A C6 99 CC 7A 00 C7 6B C6 BC BB 76 67 89 00 B8 67 76 BB 9C 79 C7 76 00 B9 CC AC 9A AA 9B AB 6A 00 A6 88 A9 76 76 C9 BC 69 00 77 CB BB CA A9 9C B8 9C 00 CA CB C9 CC 66 BB CB 6B 01 67 87 6B AB 99 22 33 00 FF FF F4 DF 44 DF D4 4F 04 7A C4 7F 24 51 64 27 F4 7F 20 C9 AC 30 03 A9 C9 99 99 CA 94 00 07 AA CC 94 8F 9C 14 07 C9 AC 20 9A 9C 00 22 9C AC CC C9 9C 0F CC C9 C9 99 00 07 00 2E 30 03 F4 73 80 00 4E 9C A9 99 C9 C9 AA 99 37 C9 A9 34 04 26 F1 BB 10 03 E0 01 F2 F8 FF B0 2F 3C C3 23 4C 03 31 00 03 C0 0E 18 20 E0 03 B9 08 09 11 02 3E 00 07 02 9B 55 55 00 E7 5B 55 11 17 22 00 04 04 33 22 10 03 07 48 A0 04 46 22 54 5F A7 77 77 69 A7 04 77 99 69 A7 A7 C0 03 99 69 07 32 22 99 69 22 F0 03 40 03 14 87 FF 00 04 F0 03 40 03 44 0F 53 F6 E4 0F F4 06 FD AA EA F0 01 F0 01 43 DF 43 03 3C 34 0B 45 34 E7 20 04 0B 29 D3 DF 43 43 09 1D 19 29 01 1A FF 18 14 1F 53 1B 53 41 12 E0 01 48 10 25 0F 15 07 F8 D0 2F F3 F6 14 0E 35 3F 35 37 9B AB 65 C2 F2 DF 82 DF AA 99 AB B9 0A 87 BA 83 03 4E 9A BA AB 9A BA 23 DF 62 DF BA 13 1F 9A F3 7F 63 7F 14 3F B9 04 3F B9 B1 00 3F B9 00 3F 10 08 AB A9 AB 10 03 00 99 9A 9A A9 B9 6C 76 B7 00 69 AB 77 CC 9B 66 CC AC 00 BC 77 C7 BB B9 66 97 BC 00 BB 77 CC A9 CC BC C9 A8 0E C9 BC AB CC 00 78 F7 9F A3 1F A9 7C AA 02 E7 97 6F 63 4F 20 0B 03 17 AA C9 19 C9 CA AA 03 3A 00 4B CA 9A 34 67 FA 04 AB 14 51 00 31 32 CB A2 FF 66 00 02 77 CC 00 02 16 D4 22 11 0E 64 00 03 34 11 01 43 33 34 11 34 33 43 00 03 52 44 02 C3 34 01 62 43 22 01 A4 32 B3 02 A3 23 00 03 00 02 22 33 42 BC 10 0B 90 32 C0 22 22 D2 AF A7 99 6A A7 2F A7 A9 00 03 AA 30 03 F2 B3 D2 BF 62 AB EB 23 1F E0 03 01 CD 59 01 CB 59 F1 E8 25 DF FF D9 CF F5 4F 70 01 00 2C EE 01 10 12 40 15 99 E7 FD 16 57 30 01 D0 0F D0 01 12 83 00 04 88 00 04 5B 11 00 04 11 00 04 04 F7 88 3C 57 15 05 FE B0 01 D0 2F F2 DF 3E 63 82 DF 90 97 06 0F AB 10 99 55 AB 76 AF 33 55 BC CC 74 C5 F5 FF 65 FF 76 BF CA 09 8A BA CC C4 05 BF 02 CB BB CB BB 06 BF BC BB 7A BA 05 BF 09 34 04 25 02 6A AA F5 BF 11 77 22 32 46 12 73 30 06 66 00 06 92 9F F5 52 EB B2 5F D0 0F 00 02 22 00 02 43 00 02 00 EB 0B 43 34 A7 AA 02 33 9A 52 37 50 0B F0 40 03 00 1B F2 33 40 03 6A 22 22 A9 FE 32 3F F2 37 80 03 F4 A7 AF AA F8 AF 84 AB 32 FF F8 9F F8 A3 E0 0B 14 A1 01 1A 44 1F D8 9F EB DF FF F8 1F 22 BF 52 BC F2 F6 B2 BF FC B7 F2 AF C0 01 56 77 00 02 77 40 02 66 D0 0F 00 02 66 FF 00 02 60 01 D2 CF D0 01 10 C2 F5 BF 70 01 D9 5F FE D0 2F F2 9F 32 9F 59 5F F1 D3 00 03 0C E4 32 4E 23 27 4B 55 77 00 F0 2B 6B 06 52 77 A8 06 5C 77 01 01 77 06 83 77 44 43 3F 34 77 04 DB F1 F7 4E FF 77 FF A0 0F D0 01 50 2B 00 5B BB 00 AF BB 2B 22 33 7B BB 0E 43 00 11 12 D3 10 03 2B 10 1F 11 EC FA 03 96 F0 DF 40 DF F6 1F 36 1F 33 06 1F 33 01 33 A9 B9 BB 9B 22 33 00 1F 7F 22 F6 3F 36 3F FF 7F 10 8F 2E CF 22 AF 8F 4F FD DB 27 41 EC B1 CF F0 01 F0 01 90 01 2B 10 C3 FF 10 03 00 08 F0 FF 10 01 07 41 84 8F D0 FF F3 5F FA B0 9F D0 0F D0 01 F2 F7 47 E2 54 23 58 86 63 5B 10 9B 02 15 BB 4B 55 00 93 0B CF 15 BB 8B 44 00 94 88 00 03 1B 21 DF F4 C3 4F D0 01 F0 5C 10 01 54 40 5F 65 66 98 B8 56 55 55 00 16 11 4F 86 65 86 00 88 88 86 88 99 AA 44 55 00 66 88 55 65 86 99 65 86 00 98 A9 66 98 A9 AA 86 99 00 BA BB 98 A9 CB CC 99 BA 03 CB CC AA CB CC DC C4 62 10 FF ED 23 B5 53 B8 D2 7F B4 00 03 10 C0 44 00 08 56 44 00 08 1B 03 7F BB 03 7F 00 08 11 7F BB 00 08 10 11 00 1E 10 03 20 DF F0 BC 29 57 F1 0D 20 5E 45 30 D0 30 BF 56 66 54 00 B8 80 00 B2 99 66 86 99 AA 88 88 08 A9 BA 54 65 00 BF 66 88 98 80 20 0F 98 AA BA 99 A9 BA BB 0A 9A AA BB CC 00 02 DC 00 02 DD E0 00 E2 20 13 00 A3 CB BB BB CB CC 44 CC 00 13 DC DD DD 60 01 BB CC 2E DD DD 00 12 DD 00 06 F0 01 00 01 42 DB 00 7C 16 C4 22 00 08 16 CD 22 00 08 16 D6 AD 00 03 42 36 DF B4 10 C3 10 03 B4 F0 CB FF 11 01 B0 01 F1 1F 01 13 10 03 F1 1F 21 1F 01 05 90 05 83 AA BA 07 33 BB AB 9B 9A 06 AB AB 9A 9A 9B 09 D3 03 93 9B 0E AB BA 9B 9A 09 51 09 2D 00 01 AA 0C B9 99 9B A9 04 73 09 E4 A9 AB 03 BA BA BB BB BA BB 03 EF 01 AF 20 BB A9 04 8E BA AB B9 9B AA FE 04 8D 03 B1 C2 AF 10 60 F2 BF 70 01 02 12 BB 80 05 00 CC AA BA CC CC BB CB 1F DC DC BC 41 2F 50 01 F1 3B B0 01 A5 6B 86 10 03 12 11 11 23 00 03 03 5C 11 68 38 00 04 B5 BF 47 07 62 47 66 55 AA 00 03 66 40 03 25 45 34 54 00 08 48 AA 00 08 81 00 08 11 00 08 11 00 08 11 E8 00 08 D0 2F D0 03 88 09 F4 89 38 33 00 23 9A 89 88 33 AA 9A 89 41 38 03 EE 88 CC BB AA 9A 00 CD 05 AB CD CC CC BC 10 97 12 00 8F C0 00 62 0A 36 23 12 88 88 33 22 43 99 00 30 9A 99 88 38 00 2F F6 37 95 29 13 12 11 05 BB 12 00 2F 22 3F CA F1 2C 0A 12 AC 20 04 44 CF 55 33 43 F1 56 ED D0 EF F0 B3 B0 03 11 00 E8 00 72 48 00 03 47 81 F0 8A 11 11 DD 00 C4 11 86 00 03 61 CD F1 7E 02 DF AA 99 89 BC 00 04 CB 00 EF 00 F3 BC AB 00 2A BC 00 2A 60 2F 04 38 33 38 23 88 00 F4 99 99 2A 89 88 04 64 89 01 1A 99 21 1F BC 2D BB BB 03 2C CC 19 45 00 EB 11 1B 3B 44 88 00 F0 88 88 38 00 2B 88 33 00 AB AA 89 88 BB AB 9A 89 AE 45 CF 43 05 CF 52 03 63 00 03 BD 72 43 3C 55 34 21 0D 11 10 C5 FF 05 5B BB 22 75 18 00 C3 10 03 11 68 18 00 08 88 00 03 A1 10 E8 88 00 10 18 18 81 11 F1 13 4F 47 19 8D AA 66 13 D1 00 5F D0 0F F0 01 FC E0 01 0E 4F 7E 36 41 3B F0 01 52 DF BC AA 4F 89 11 3B DD CD 21 3B E1 6B F6 72 20 01 5C 44 00 02 44 15 7C 40 B3 00 07 55 33 D4 00 0F E6 0F 88 00 F0 55 00 04 55 55 2F 88 18 02 43 88 12 31 02 45 14 EF 15 62 E7 0A C7 F0 01 12 10 44 45 03 43 0C FA F7 F2 FF 15 8A 71 0B D0 0F E8 4C 00 4B 10 04 10 09 FF 2E 3B AA AA D0 7B D0 2F F0 FB 66 00 13 A1 9F FF F2 D7 21 0F 31 1F 10 53 10 04 10 09 10 CF 30 F5 FE 70 04 82 FF 60 01 90 2F F5 72 26 3F 10 02 AA B8 00 02 AA D3 9F 1D 43 20 D8 EA AE AA 0F EA EE EE AE DD 8F 50 7A 07 18 1D 5B D4 20 7F 00 6A 48 00 6A 81 F0 9F 44 55 8D F4 9F 25 22 44 00 08 06 B2 25 00 20 F7 9B 5F 62 FF 06 3C 09 D9 22 24 2E 1B 40 10 04 27 33 34 28 5A 44 43 26 F4 70 33 00 AC 5A EA 00 02 EE 10 03 00 26 EA 30 95 33 CF 07 F7 30 7F EE EE B0 01 10 D3 10 DB 48 B0 57 44 00 09 44 00 11 AA 10 03 10 0B 10 3D DF 00 02 51 25 44 10 BF 26 D0 00 04 1B D6 D0 DF FF F6 FF 40 08 20 11 10 1A E6 FF 5B C7 20 EF D2 7F EC 60 EF 4C 9A 07 AC 99 03 8C 0A 31 AA 9B 55 BB 0A 3F B9 5A 3F B9 1A 3F BB 0B 57 40 C9 00 19 CC BC 6A C6 99 CC 00 7A C7 6B C6 BC BB 76 67 00 89 B8 67 76 BB 9C 79 C7 00 76 B9 CC AC 66 97 BB 9B 00 77 9B 9B 9B 6A C6 CC BB 08 7A A7 A9 BC 04 B2 BB 9C BC 00 AA AA 8C BA AA 99 CB A9 21 BB B9 07 2B AB 9A AB BB 0B 93 00 BA 9B A9 AA BA AB BA B9 16 BA 33 AB 07 04 AB 36 F7 01 0F 22 3F 33 9A 00 0C 40 0F 42 24 72 13 41 AF 11 1A F0 F1 1F F1 DF 51 DF 60 2F 77 B9 BC CC 48 CA FE DF AC 66 0E DF 76 C7 C8 FF 10 DC F0 7F F2 D4 F2 DF 30 02 D2 DF 01 87 52 E0 FF 8A 1F 00 05 10 0A 1A 42 07 CC 90 04 E0 6A 10 30 EF 4A 54 DD 9F 50 49 BB 00 70 0F C7 36 E7 20 7F DD 08 CA 01 E4 99 D4 66 20 74 80 3C 99 12 28 FE 00 04 00 7A 00 1A 30 84 F0 DF B0 2F 81 4F 52 B7 00 04 42 D1 7F 53 2F 34 F1 7F 22 A4 91 0F BF F0 FF AA DF 5F 10 2D C0 FF 21 24 60 EF 1F 1D F7 FC 1F 90 EF B1 1F 00 EA 55 01 1B F1 1F 40 2F FF FE 3F 02 9F 3D 35 3B 01 C3 2F EF C0 13 BB 00 04 72 88 00 04 0B 6A 04 AF 88 33 05 19 33 FE 00 02 20 3F 30 A7 3F D5 F2 5F 3B C1 40 B7 AA FF 10 EC D1 5F F1 1F BF BF 22 2F 42 5F F1 3F 71 93 FE FF 5F 30 01 D0 CF D0 2F 19 40 20 B7 10 BF 13 AE 10 05 11 10 0D 11 10 16 22 F5 CF FF 33 9E 0C DC 33 33 0F F7 00 04 11 04 F7 3E 11 FF A1 1F C0 0F E1 1F FE 97 3D D6 50 7F 70 0F A0 37 FF 21 02 B3 3C 62 87 32 06 00 02 11 5C 15 E2 00 03 75 43 F0 5F 30 5F 1B 20 59 00 0F 59 F4 17 88 20 5F AA AA 54 00 6C 45 55 54 7F 54 10 3A 30 44 9B CF 82 3F 90 CB 60 01 50 18 0A 22 44 33 34 03 2D 34 03 3C 44 9F 16 9C 43 43 40 47 80 FF 03 69 F0 FF F0 FF FF A0 9F 16 E5 23 88 13 91 13 9A 01 68 0A 52 10 03 FF 2C 0F F3 F6 30 37 13 79 00 2A 10 72 20 5F F3 7F F0 32 1F 84 97 F3 7F 00 04 FF FF 33 22 00 EF BF 3A 33 EF CD AB AA 00 EF DD BC BB FF DE CC BC 00 FF EE DD CC FF EF EE DE 0F FF FF FF EE 0B FA 0A DF 00 90 0C 94 00 AA 3A 23 12 BB AB 3A 22 A7 09 F3 33 00 2A AA EE 09 F3 50 A7 F0 03 DF 30 03 00 39 53 00 04 10 03 F0 01 40 DF 40 CF 7F 54 00 CF 08 CB 22 93 62 97 2E E7 F2 FF 10 DB 40 55 0C 68 55 EF DD CC BB EF 25 DE CD 00 AF DE DD 00 AE EE 00 B3 7E EF 00 03 60 01 00 85 FA 23 80 01 12 63 55 EF 00 04 03 30 09 CB 55 10 2B A0 2F D9 EF D0 2F 50 AA 0B F8 BB 00 04 BB AB AA 33 A4 0C 13 AA 0C 43 BB DC 4B 07 EE EE 74 DE 2D DF 11 07 11 D0 AA 00 04 AB AA 89 00 2F AB 3A 33 0C 43 AA CD 0D 63 FF ED 3B 4E 03 10 2F 01 6E A9 CF 1A 0E 12 43 36 CE FB 22 63 F0 DB C0 2F D0 CF D0 01 EE 01 EC 01 32 E1 11 37 F0 01 00 01 DD CD BB BB 02 0E 97 00 CB CD CD 00 2A CD 52 17 51 67 00 D3 58 22 00 CE 33 15 B8 0D 12 AB CD BB 20 CB BC 00 2E CC EE DD DC CD 17 EE DE ED A0 FF 3A 02 48 07 C7 11 2F 3F 33 BC 01 30 01 2A F0 FF 12 6F 00 F6 10 FB FF 11 5B 53 4C 10 F1 00 D0 00 CB 20 D4 20 D8 20 DC FE FE 40 A0 2F D1 2F D0 01 81 DA 24 05 00 02 54 A9 02 71 54 03 57 54 00 1E 54 EF 01 C4 18 FF EE FE E2 57 61 1F CC BB BB 91 0E 2E BB DE 11 23 DE DD DD 01 23 70 DD 01 23 61 4F 01 1B 23 BB AA 3A F9 00 EF 01 EF 00 EF 10 2B 01 46 CC EF 31 4B 66 DD 31 EB 10 EB 22 12 00 26 22 1B BC DF 12 4B 0A 14 CD 01 20 91 1B 12 0D 20 2F 31 1B 7F 12 00 AF 33 62 F0 01 31 4B 22 3E B1 2F D0 01 FF F2 DF 62 DF 03 83 25 5E 21 07 80 03 06 4F 20 03 BF 10 0B 64 02 0A 52 0F F0 01 11 1F 11 17 03 0C ED 01 12 10 23 10 03 FE 90 1F 00 EB 3A 00 EB 7E AB 00 26 01 43 33 33 03 C6 00 53 32 93 33 15 22 55 45 04 AC 55 01 3E 66 22 33 CA 11 6F 22 8F DD DD 02 BB EE 11 DB 66 04 56 45 44 A6 6A 10 B5 66 56 BA 00 22 66 03 56 13 5B 11 97 CC 55 33 45 B1 22 07 45 0E 77 0A D3 66 66 56 0B 4F B8 00 4F BB A9 7F 3A 3D 22 16 65 56 65 BA 1D AA A6 A0 1F 00 3E 10 43 54 00 3E 55 0D A5 AA 66 55 0F DF 19 82 74 40 03 A0 0D B1 74 00 03 87 88 45 88 98 00 A9 88 99 99 BA 99 A9 AA 7F CB F5 12 B0 03 11 43 F0 03 70 03 02 74 51 37 E2 F0 01 00 01 01 33 DD EE DE 1C D9 FE F9 F2 9F 00 01 12 43 62 73 22 9F DE ED 32 9F D2 32 A3 2F 02 AA 03 B4 BB CC 04 B6 DC 5A DD 00 22 ED 10 4D 50 4C CB 01 A0 DC 9F 21 73 CD BC 01 9A 21 77 30 3F 30 21 00 3E 04 DC BA BB CC ED 04 F4 EE CC 8F 01 91 DD ED FE 40 59 55 7F F0 F3 02 8C FF 06 97 10 03 06 FE F3 BE A7 2B F0 1F 43 DF 02 7D FF 43 DE DB FC A3 EF 0E 67 40 03 30 1A D0 03 F1 73 FF 20 03 60 83 F0 7E B0 A3 40 6A 67 EF F7 AE B7 AF 80 D6 DF 00"

setByteString(blueRom, 0x4BAE9E, editedBytes)

blueData:write_file("exe3b/rom_b.srl", blueRom)

--[[
-- Modify English values for alphabetical chip ordering in memory.
-- (WIP; should locate the original (4-byte, though only up to 2 are used) values in memory instead of using fixed addresses.)

local alphabetOriginal = "3F 00 89 00 AD 00 02 00 03 00 04 00 A3 00 A4 00 A5 00 0E 01 2B 01 10 01 1B 01 33 00 3A 00 39 00 85 00 87 00 86 00 BA 00 15 01 59 00 29 01 3E 00 8D 00 A2 00 27 00 28 00 29 00 1F 01 2F 01 A9 00 61 00 11 00 5C 00 1A 00 45 00 2A 01 1E 01 1D 01 D2 00 08 00 11 01 0D 01 16 01 5A 00 7D 00 83 00 7C 00 05 00 06 00 07 00 4C 00 3C 00 26 01 27 01 28 01 E9 00 EA 00 EB 00 2E 01 F4 00 C4 00 84 00 25 01 35 01 36 01 37 01 32 01 33 01 34 01 17 01 18 01 19 01 A1 00 04 01 C3 00 FF 00 00 01 01 01 AA 00 AB 00 AC 00 2B 00 2C 00 2D 00 F6 00 8B 00 0F 01 8F 00 90 00 91 00 DC 00 DD 00 DE 00 13 00 14 00 15 00 23 01 B9 00 05 01 06 01 07 01 42 00 43 00 44 00 75 00 E0 00 DF 00 0A 01 0B 01 0C 01 26 00 2C 01 40 00 3D 00 60 00 7A 00 D4 00 D5 00 EC 00 F0 00 F2 00 F3 00 ED 00 EE 00 EF 00 F1 00 D3 00 12 00 13 01 21 01 AE 00 AF 00 B0 00 77 00 78 00 72 00 73 00 74 00 FA 00 E2 00 30 01 5D 00 F7 00 F8 00 F9 00 CD 00 CE 00 CF 00 D6 00 A0 00 FE 00 CA 00 CB 00 CC 00 12 01 6E 00 F5 00 92 00 8A 00 C0 00 C1 00 C2 00 09 01 B8 00 3B 00 01 00 22 01 5E 00 53 00 24 01 1D 00 1B 00 1C 00 18 00 D0 00 8C 00 A6 00 8E 00 79 00 03 01 B7 00 14 01 20 01 1A 01 C6 00 99 00 9A 00 0C 00 0B 00 0E 00 0D 00 41 00 16 00 5F 00 10 00 5B 00 31 01 C7 00 A7 00 C5 00 7B 00 0F 00 17 00 C8 00 88 00 38 01 76 00 D1 00 6F 00 B6 00 E1 00 98 00 1C 01 2D 01 A8 00 71 00 FB 00 FC 00 FD 00 7E 00 7F 00 80 00 81 00 82 00 E3 00 E4 00 E5 00 E6 00 E7 00 67 00 68 00 69 00 6A 00 6B 00 21 00 22 00 23 00 24 00 25 00 34 00 35 00 36 00 37 00 38 00 4E 00 4F 00 50 00 51 00 52 00 D7 00 D8 00 D9 00 DA 00 DB 00 62 00 63 00 64 00 65 00 66 00 54 00 55 00 56 00 57 00 58 00 B1 00 B2 00 B3 00 B4 00 B5 00 E8 00 02 01 6D 00 2A 00 70 00 9B 00 9C 00 9D 00 9E 00 9F 00 BB 00 BC 00 BD 00 BE 00 BF 00 2E 00 2F 00 30 00 31 00 32 00 47 00 48 00 49 00 4A 00 4B 00 93 00 94 00 95 00 96 00 97 00 4D 00 6C 00 C9 00 0A 00 1E 00 08 01 19 00 46 00 09 00 1F 00 20 00"

local alphabetNew = "3F 00 89 00 A8 00 02 00 03 00 04 00 9E 00 9F 00 A0 00 09 01 26 01 0B 01 16 01 33 00 3A 00 39 00 85 00 87 00 86 00 B5 00 10 01 59 00 24 01 3E 00 8D 00 9D 00 27 00 28 00 29 00 1A 01 2A 01 A4 00 61 00 11 00 5C 00 1A 00 45 00 25 01 19 01 18 01 CD 00 08 00 0C 01 08 01 11 01 5A 00 7D 00 83 00 7C 00 05 00 06 00 07 00 4C 00 3C 00 21 01 22 01 23 01 E4 00 E5 00 E6 00 29 01 EF 00 BF 00 84 00 20 01 35 01 36 01 37 01 32 01 33 01 34 01 12 01 13 01 14 01 9C 00 FF 00 BE 00 FA 00 FB 00 FC 00 A5 00 A6 00 A7 00 2B 00 2C 00 2D 00 F1 00 8B 00 0A 01 8F 00 90 00 91 00 D7 00 D8 00 D9 00 13 00 14 00 15 00 1E 01 B4 00 00 01 01 01 02 01 42 00 43 00 44 00 75 00 DB 00 DA 00 05 01 06 01 07 01 26 00 27 01 40 00 3D 00 60 00 7A 00 CF 00 D0 00 E7 00 E8 00 E9 00 EA 00 EB 00 EC 00 ED 00 EE 00 CE 00 12 00 0E 01 1C 01 A9 00 AA 00 AB 00 77 00 78 00 72 00 73 00 74 00 F5 00 DD 00 2B 01 5D 00 F2 00 F3 00 F4 00 C8 00 C9 00 CA 00 D1 00 9B 00 F9 00 C5 00 C6 00 C7 00 0D 01 6E 00 F0 00 92 00 8A 00 BB 00 BC 00 BD 00 04 01 B3 00 3B 00 01 00 1D 01 5E 00 53 00 1F 01 1D 00 1B 00 1C 00 18 00 CB 00 8C 00 A1 00 8E 00 79 00 FE 00 B2 00 0F 01 1B 01 15 01 C1 00 94 00 95 00 0C 00 0B 00 0E 00 0D 00 41 00 16 00 5F 00 10 00 5B 00 2C 01 C2 00 A2 00 C0 00 7B 00 0F 00 17 00 C3 00 88 00 38 01 76 00 CC 00 6F 00 B1 00 DC 00 93 00 17 01 28 01 A3 00 71 00 F6 00 F7 00 F8 00 7E 00 7F 00 80 00 81 00 82 00 DE 00 DF 00 E0 00 E1 00 E2 00 67 00 68 00 69 00 6A 00 6B 00 21 00 22 00 23 00 24 00 25 00 34 00 35 00 36 00 37 00 38 00 4E 00 4F 00 50 00 51 00 52 00 D2 00 D3 00 D4 00 D5 00 D6 00 62 00 63 00 64 00 65 00 66 00 54 00 55 00 56 00 57 00 58 00 AC 00 AD 00 AE 00 AF 00 B0 00 E3 00 FD 00 6D 00 2A 00 70 00 96 00 97 00 98 00 99 00 9A 00 B6 00 B7 00 B8 00 B9 00 BA 00 2E 00 2F 00 30 00 31 00 32 00 47 00 48 00 49 00 4A 00 4B 00 2D 01 2E 01 2F 01 30 01 31 01 4D 00 6C 00 C4 00 09 00 1E 00 03 01 19 00 46 00 0A 00 1F 00 20 00"

local oldBytes = {}
for byte in alphabetOriginal:gmatch("%S+") do
	table.insert(oldBytes, byte)
end

local newBytes = {}
for byte in alphabetNew:gmatch("%S+") do
	table.insert(newBytes, byte)
end

for version = 1, 2 do
	local memoryIndex = 0x141EB7114  -- White
	if version == 2 then memoryIndex = 0x141EB8C24 end -- Blue
	local alphabetMemory = chaudloader.unsafe.read_process_memory(memoryIndex, 0x4E0)
	
	for i = 1, #oldBytes, 2 do
		if oldBytes[i] == newBytes[i] and oldBytes[i + 1] == newBytes[i + 1] then goto continue end
		
		local oldValue = oldBytes[i] .. " " .. oldBytes[i + 1]
		local bigEndValue = string.upper(string.format("%04x", alphabetMemory:get_u16_le((i - 1) * 2)))
		local littleEndValue = string.sub(bigEndValue, 3, 4) .. " " .. string.sub(bigEndValue, 1, 2)
		if oldValue == littleEndValue then
			chaudloader.unsafe.write_process_memory(memoryIndex + ((i - 1) * 2), chaudloader.buffer.from_u8_table({ tonumber(newBytes[i], 16), tonumber(newBytes[i + 1], 16) }))
		end
		::continue::
	end
end
]]