

/*:
 * @plugindesc イベントで決定キーを押し続けた時の早送りスピードを変更します。
 *
 * @author くわん
 *
 * @param speed
 * @type number
 * @desc 早送りの速度を何倍速にするかを整数で指定します。
 * 初期値: 8
 * @default 8
 * @min 1
 *
 *
 * プラグインコマンド:
 *
 *   eventFastForwardSpeed 8
 *     早送りの速度を何倍速にするかを整数で指定します。（セーブ未対応）
 */

var Imported = Imported || {};
Imported.GNG_EventFastForward = true;

var GNG_Plugin = GNG_Plugin || {};
GNG_Plugin.EventFastForward = {};
GNG_Plugin.EventFastForward.Parameters    = PluginManager.parameters('GNG_EventFastForward');
GNG_Plugin.EventFastForward.Speed      = +(GNG_Plugin.EventFastForward.Parameters['speed'] || 8);


Scene_Map.prototype.updateMainMultiply = function() {
    this.updateMain();
    if (this.isFastForward()) {
        for(var i=0;i<GNG_Plugin.EventFastForward.Speed-1;i++){
            this.updateMain();
        }
    }
};


  var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
  Game_Interpreter.prototype.pluginCommand = function(command, args) {
    _Game_Interpreter_pluginCommand.call(this, command, args);
    if (command === 'eventFastForwardSpeed') {
      anum = args.map(Number);
      var spd = Math.max(1,anum[0]);
      GNG_Plugin.EventFastForward.Speed = spd;
    }
  };