

/*:
 * @plugindesc ウィンドウのオープン方式を変更します。
 *
 * @author くわん
 *
 * @param openType
 * @type number
 * @desc ウィンドウオープン方式を番号で指定します。
 * 0:デフォルト　1:縦横に広がる　2:縦に移動　3:横に移動
 * 初期値: 2
 * @default 2
 *
 * @param openSlideLength
 * @type number
 * @desc ウィンドウオープン方式2または3のとき移動する距離を指定します。
 * ＋の値で→または↓方向、－の値で←または↑方向に移動します。
 * 初期値: -80
 * @default -80
 * @min -9999
 *
 * @param openSpeedType
 * @type number
 * @desc ウィンドウオープン速度の方式を指定します。
 * 0:等速　1:次第にゆっくり（割合減速）
 * 初期値: 0
 * @default 0
 *
 * @param openSpeed
 * @type number
 * @desc ウィンドウオープン速度を指定します。
 * 初期値: 32
 * @default 32
 *
 * @param closeType
 * @type number
 * @desc ウィンドウクローズ方式を番号で指定します。
 * 0:デフォルト　1:縦横に広がる　2:縦に移動　3:横に移動
 * 初期値: 2
 * @default 2
 *
 * @param closeSlideLength
 * @type number
 * @desc ウィンドウクローズ方式2または3のとき移動する距離を指定します。
 * ＋の値で←または↑方向、－の値で→または↓方向に移動します。
 * 初期値: -80
 * @default -80
 * @min -9999
 *
 * @param closeSpeedType
 * @type number
 * @desc ウィンドウクローズ速度の方式を指定します。
 * 0:等速　1:次第にゆっくり（割合減速）
 * 初期値: 0
 * @default 0
 *
 * @param closeSpeed
 * @type number
 * @desc ウィンドウクローズ速度を指定します。
 * 初期値: 32
 * @default 32
 */

var Imported = Imported || {};
Imported.GNG_WindowOpenType = true;

var GNG_Plugin = GNG_Plugin || {};
GNG_Plugin.WindowOpenType = {};
GNG_Plugin.WindowOpenType.Parameters    = PluginManager.parameters('GNG_WindowOpenType');
GNG_Plugin.WindowOpenType.OpenType      = +(GNG_Plugin.WindowOpenType.Parameters['openType'] || 2);
GNG_Plugin.WindowOpenType.OpenSlideLength   = +(GNG_Plugin.WindowOpenType.Parameters['openSlideLength'] || -80);
GNG_Plugin.WindowOpenType.OpenSpeedType = +(GNG_Plugin.WindowOpenType.Parameters['openSpeedType'] || 0);
GNG_Plugin.WindowOpenType.OpenSpeed      = +(GNG_Plugin.WindowOpenType.Parameters['openSpeed'] || 32);
GNG_Plugin.WindowOpenType.CloseType      = +(GNG_Plugin.WindowOpenType.Parameters['closeType'] || 2);
GNG_Plugin.WindowOpenType.CloseSlideLength   = +(GNG_Plugin.WindowOpenType.Parameters['closeSlideLength'] || -80);
GNG_Plugin.WindowOpenType.CloseSpeedType = +(GNG_Plugin.WindowOpenType.Parameters['closeSpeedType'] || 0);
GNG_Plugin.WindowOpenType.CloseSpeed      = +(GNG_Plugin.WindowOpenType.Parameters['closeSpeed'] || 32);


var _WindowInitialize = Window.prototype.initialize;
Window.prototype.initialize = function() {
  _WindowInitialize.call(this);
  this._trueOpacity = 255;
};

Object.defineProperty(Window.prototype, 'opacity', {
    get: function() {
        return this._trueOpacity;
        return this._windowSpriteContainer.alpha * 255;
    },
    set: function(value) {
        this._trueOpacity = value.clamp(0, 255);
        this._windowSpriteContainer.alpha = this._trueOpacity * (this.openness/255) / 255;
    },
    configurable: true
});

//var _WindowOpennessSet = Window.prototype.openness.setter;
Object.defineProperty(Window.prototype, 'openness', {
    get: function() {
        return this._openness;
    },
    set: function(value) {
      if (this._openness !== value) {
        if(this._openness < value){
          this._openness = value.clamp(0, 255);
          if (GNG_Plugin.WindowOpenType.OpenType <= 1){
            this._windowSpriteContainer.scale.y = this._openness / 255;
            this._windowSpriteContainer.y = this.height / 2 * (1 - this._openness / 255);
            this._windowSpriteContainer.alpha = this._trueOpacity;
          }
          if (GNG_Plugin.WindowOpenType.OpenType == 1){
            this._windowSpriteContainer.scale.x = this._openness / 255;
            this._windowSpriteContainer.x = this.width / 2 * (1 - this._openness / 255);
            this._windowSpriteContainer.alpha = this._trueOpacity;
          }
          if (GNG_Plugin.WindowOpenType.OpenType == 2){
            this._windowSpriteContainer.y = -GNG_Plugin.WindowOpenType.OpenSlideLength * (1 - this._openness / 255);
            this._windowSpriteContainer.alpha = this._trueOpacity * (this.openness/255) / 255;
          }
          if (GNG_Plugin.WindowOpenType.OpenType == 3){
            this._windowSpriteContainer.x = -GNG_Plugin.WindowOpenType.OpenSlideLength * (1 - this._openness / 255);
            this._windowSpriteContainer.alpha = this._trueOpacity * (this.openness/255) / 255;
          }
        }else{
          this._openness = value.clamp(0, 255);
          if (GNG_Plugin.WindowOpenType.CloseType <= 1){
            this._windowSpriteContainer.scale.y = this._openness / 255;
            this._windowSpriteContainer.y = this.height / 2 * (1 - this._openness / 255);
            this._windowSpriteContainer.alpha = this._trueOpacity;
          }
          if (GNG_Plugin.WindowOpenType.CloseType == 1){
            this._windowSpriteContainer.scale.x = this._openness / 255;
            this._windowSpriteContainer.x = this.width / 2 * (1 - this._openness / 255);
            this._windowSpriteContainer.alpha = this._trueOpacity;
          }
          if (GNG_Plugin.WindowOpenType.CloseType == 2){
            this._windowSpriteContainer.y = -GNG_Plugin.WindowOpenType.CloseSlideLength * (1 - this._openness / 255);
            this._windowSpriteContainer.alpha = this._trueOpacity * (this.openness/255) / 255;
          }
          if (GNG_Plugin.WindowOpenType.CloseType == 3){
            this._windowSpriteContainer.x = -GNG_Plugin.WindowOpenType.CloseSlideLength * (1 - this._openness / 255);
            this._windowSpriteContainer.alpha = this._trueOpacity * (this.openness/255) / 255;
          }
        }
      }
    },
    configurable: true
});


var _Window_Base_UpdateOpen = Window_Base.prototype.updateOpen;
Window_Base.prototype.updateOpen = function() {
    if (this._opening) {
        if (GNG_Plugin.WindowOpenType.OpenSpeedType == 0){
          this.openness += GNG_Plugin.WindowOpenType.OpenSpeed;
        }else{
          this.openness += Math.max(1,(255 - this.openness) / (255 / GNG_Plugin.WindowOpenType.OpenSpeed));
        }
        if (this.isOpen()) {
            this._opening = false;
        }
    }
};

var _Window_Base_UpdateClose = Window_Base.prototype.updateClose;
Window_Base.prototype.updateClose = function() {
    if (this._closing) {
        if (GNG_Plugin.WindowOpenType.CloseSpeedType == 0){
          this.openness -= GNG_Plugin.WindowOpenType.CloseSpeed;
        }else{
          this.openness -= Math.max(1,this.openness / (255 / GNG_Plugin.WindowOpenType.CloseSpeed));
        }
        if (this.isClosed()) {
            this._closing = false;
        }
    }
};