//=============================================================================
// Plugin_Name : RX_T_CallEvent_in_Map
// File_Name   : RX_T_CallEvent_in_Map.js
// Version     : 1.00
// Copylight   : 2015 TYPE74RX-T
//=============================================================================


//=============================================================================
/*:
 * @plugindesc マップ内に設定したイベントを他のイベントから呼び出すことができます。
 * @author TYPE74RX-T
 * @help マップ内イベント呼び出し
 * ============================================================================
 * * マップ内イベント呼び出し・ヘルプ
 * ============================================================================
 * マップ内に設定したイベントを他のイベントから呼び出すことができます。
 * 基本的にはコモンイベントの呼び出しで事足りますが 
 * 場合によってはこちらの方が便利になる場合もあるかもしれません。 
 * ============================================================================
 * * 使い方
 * ============================================================================
 * イベントコマンド「スクリプト」で呼び出します。
 * 例：イベントID3のイベントを呼び出す場合
 *
 * this.call_ev(3);
 *
 * 【仕様】
 * 呼び出されたイベントは、「イベントの呼び出し」が発動するイベントを
 * 発動する前のページを参照します。
 *
 * 例えば、別のイベントを呼び出すイベントをイベント1
 * そして呼び出される側のイベントをイベント2とします。
 * そのイベント2は、通常「いらっしゃいませ」と言いますが、スイッチ1がONのときに
 * 「なんの　ようだ！」と言うイベントです。
 *
 * イベント1のイベントを発動させ、スイッチ1をONにした後イベント2を呼び出しても
 * イベント2は「イベント1を発動させる前」の状態になっているため
 * （グラフィックの変化がある場合、グラフィックは変化します。）
 * 「なんの　ようだ！」ではなく「いらっしゃいませ」と言います。
 *
 * この場合、再度イベント1を発動させると、スイッチ1がONであるため
 * イベント2は「なんの　ようだ！」と言うようになります。
 * ============================================================================
 * * ドキュメント終了 
 * ============================================================================
*/
(function() {
	
	//Game_Interpreter
	
    Game_Interpreter.prototype.call_ev = function(eventId) {
        var rxEvent = $gameMap.event(eventId).page();
        if (rxEvent) {
            eventId = this.isOnCurrentMap() ? eventId : 0;
            this.setupChild(rxEvent.list, eventId);
        }
        return true;
    };

})();