//=============================================================================
// TMPlugin - ACeIg
// o[W: 1.1.0
// ŏIXV: 2017/01/24
// zz    : http://hikimoki.sakura.ne.jp/
//-----------------------------------------------------------------------------
// Copyright (c) 2016 tomoaky
// Released under the MIT license.
// http://opensource.org/licenses/mit-license.php
//=============================================================================

/*:
 * @plugindesc ACeȈɃwvEBhEǉA
 * \̗Lƕ\sACe^CvƂɐݒł܂B
 *
 * @author tomoaky (http://hikimoki.sakura.ne.jp/)
 *
 * @param helpWindowEnabledItem
 * @desc ACeIŃwvEBhE\邩ǂ
 * l: 1i 0 ŕ\Ȃj
 * @default 1
 *
 * @param helpWindowEnabledKey
 * @desc 厖Ȃ̑IŃwvEBhE\邩ǂ
 * l: 1i 0 ŕ\Ȃj
 * @default 1
 *
 * @param helpWindowEnabledA
 * @desc BACe`IŃwvEBhE\邩ǂ
 * l: 1i 0 ŕ\Ȃj
 * @default 1
 *
 * @param helpWindowEnabledB
 * @desc BACeaIŃwvEBhE\邩ǂ
 * l: 1i 0 ŕ\Ȃj
 * @default 1
 *
 * @param showItemNumberItem
 * @desc ACě\邩ǂ
 * l: 1i 0 ŕ\Ȃj
 * @default 1
 *
 * @param showItemNumberKey
 * @desc 厖Ȃ̂̌\邩ǂ
 * l: 1i 0 ŕ\Ȃj
 * @default 1
 *
 * @param showItemNumberA
 * @desc BACe`̌\邩ǂ
 * l: 1i 0 ŕ\Ȃj
 * @default 1
 *
 * @param showItemNumberB
 * @desc BACe`̌\邩ǂ
 * l: 1i 0 ŕ\Ȃj
 * @default 1
 *
 * @param numVisibleRowsItem
 * @desc ACeI̕\s
 * l: 4
 * @default 4
 *
 * @param numVisibleRowsKey
 * @desc 厖Ȃ̑I̕\s
 * l: 4
 * @default 4
 *
 * @param numVisibleRowsA
 * @desc BACe`I̕\s
 * l: 4
 * @default 4
 *
 * @param numVisibleRowsB
 * @desc BACeaI̕\s
 * l: 4
 * @default 4
 *
 * @param fixPlacement
 * @desc bZ[WEBhEȂꍇ̃EBhEʒu
 * l: top ( top / bottom / ݒŌŒ肵Ȃ )
 * @default top
 *
 * @help
 * TMPlugin - ACeIg ver1.1.0
 *
 * g:
 *
 *   ACe^CvƂɈȉ̐ݒύXł܂B
 *   EwvEBhE\邩ǂ
 *   E\邩ǂ
 *   EACeIEBhE̕\s
 * 
 *   ^OƃvOCR}hgAƂĕ\ACe
 *   ɍׂނ邱Ƃł܂B
 *
 *   ̃vOC RPGcN[MV Version 1.3.4 œmFĂ܂B
 * 
 * 
 * ^OiACej:
 * 
 *   <subCategory:card>
 *     ̃^OĂACeɃTuJeS[Ƃ card ݒ肵܂B 
 * 
 * 
 * vOCR}h:
 * 
 *   setEventItemSubCategory card
 *     CxgR}hwACeȈx̒OɎs邱ƂŁA
 *     w肵TuJeS[̃ACê݂\邱Ƃł܂B
 *     Ƃ΁ACxgR}h 厖Ȃ IĂꍇA
 *     Ă厖Ȃ̂̒TuJeS[ card ݒ肳Ă
 *     ACê݂\܂B
 * 
 *     ̃R}ȟʂ̓ACeIi܂̓LZj
 *     Zbg܂B
 */

var Imported = Imported || {};
Imported.TMEventItemEx = true;

var TMPlugin = TMPlugin || {};
TMPlugin.EventItemEx = {};
TMPlugin.EventItemEx.Parameters = PluginManager.parameters('TMEventItemEx');
TMPlugin.EventItemEx.HelpWindowEnabledItem = TMPlugin.EventItemEx.Parameters['helpWindowEnabledItem'] === '1';
TMPlugin.EventItemEx.HelpWindowEnabledKey = TMPlugin.EventItemEx.Parameters['helpWindowEnabledKey'] === '1';
TMPlugin.EventItemEx.HelpWindowEnabledA = TMPlugin.EventItemEx.Parameters['helpWindowEnabledA'] === '1';
TMPlugin.EventItemEx.HelpWindowEnabledB = TMPlugin.EventItemEx.Parameters['helpWindowEnabledB'] === '1';
TMPlugin.EventItemEx.ShowItemNumberItem = TMPlugin.EventItemEx.Parameters['showItemNumberItem'] === '1';
TMPlugin.EventItemEx.ShowItemNumberKey  = TMPlugin.EventItemEx.Parameters['showItemNumberKey'] === '1';
TMPlugin.EventItemEx.ShowItemNumberA    = TMPlugin.EventItemEx.Parameters['showItemNumberA'] === '1';
TMPlugin.EventItemEx.ShowItemNumberB    = TMPlugin.EventItemEx.Parameters['showItemNumberB'] === '1';
TMPlugin.EventItemEx.NumVisibleRowsItem = +(TMPlugin.EventItemEx.Parameters['numVisibleRowsItem'] || 4);
TMPlugin.EventItemEx.NumVisibleRowsKey  = +(TMPlugin.EventItemEx.Parameters['numVisibleRowsKey'] || 4);
TMPlugin.EventItemEx.NumVisibleRowsA    = +(TMPlugin.EventItemEx.Parameters['numVisibleRowsA'] || 4);
TMPlugin.EventItemEx.NumVisibleRowsB    = +(TMPlugin.EventItemEx.Parameters['numVisibleRowsB'] || 4);
TMPlugin.EventItemEx.FixPlacement       = TMPlugin.EventItemEx.Parameters['fixPlacement'];

(function() {

  //-----------------------------------------------------------------------------
  // Game_Temp
  //

  Game_Temp.prototype.setEventItemSubCategory = function(category) {
    this._eventItemSubCategory = category;
  };

  Game_Temp.prototype.eventItemSubCategory = function() {
    return this._eventItemSubCategory;
  };

  //-----------------------------------------------------------------------------
  // Game_Interpreter
  //

  var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
  Game_Interpreter.prototype.pluginCommand = function(command, args) {
    _Game_Interpreter_pluginCommand.call(this, command, args);
    if (command === 'setEventItemSubCategory') {
      $gameTemp.setEventItemSubCategory(args[0]);
    }
  };
  
  //-----------------------------------------------------------------------------
  // Window_EventItem
  //

  Window_EventItem.prototype.isHelpWindowEnabled = function() {
    var itypeId = $gameMessage.itemChoiceItypeId();
    if (itypeId === 1) {
      return TMPlugin.EventItemEx.HelpWindowEnabledItem;
    } else if (itypeId === 2) {
      return TMPlugin.EventItemEx.HelpWindowEnabledKey;
    } else if (itypeId === 3) {
      return TMPlugin.EventItemEx.HelpWindowEnabledA;
    } else if (itypeId === 4) {
      return TMPlugin.EventItemEx.HelpWindowEnabledB;
    }
    return false;
  };

  var _Window_EventItem_start = Window_EventItem.prototype.start;
  Window_EventItem.prototype.start = function() {
    this.height = this.fittingHeight(this.numVisibleRows());
    _Window_EventItem_start.call(this);
    if (this.isHelpWindowEnabled()) this._helpWindow.open();
  };

  var _Window_EventItem_numVisibleRows = Window_EventItem.prototype.numVisibleRows;
  Window_EventItem.prototype.numVisibleRows = function() {
    var itypeId = $gameMessage.itemChoiceItypeId();
    if (itypeId === 1) {
      return TMPlugin.EventItemEx.NumVisibleRowsItem;
    } else if (itypeId === 2) {
      return TMPlugin.EventItemEx.NumVisibleRowsKey;
    } else if (itypeId === 3) {
      return TMPlugin.EventItemEx.NumVisibleRowsA;
    } else if (itypeId === 4) {
      return TMPlugin.EventItemEx.NumVisibleRowsB;
    }
    return _Window_EventItem_numVisibleRows.call(this);
  };

  var _Window_EventItem_updatePlacement = Window_EventItem.prototype.updatePlacement;
  Window_EventItem.prototype.updatePlacement = function() {
    var enabled = this.isHelpWindowEnabled();
    if (!$gameMessage.hasText() && TMPlugin.EventItemEx.FixPlacement) {
      if (TMPlugin.EventItemEx.FixPlacement === 'top') {
        this.y = enabled ? this._helpWindow.height : 0;
      } else {
        this.y = Graphics.boxHeight - this.height;
      }
    } else if (enabled) {
      if (this._messageWindow.y >= Graphics.boxHeight / 2) {
        this.y = this._helpWindow.height;
      } else {
        this.y = Graphics.boxHeight - this.height;
      }
    } else {
      _Window_EventItem_updatePlacement.call(this);
    }
    if (enabled) this._helpWindow.y = this.y - this._helpWindow.height;
  };

  var _Window_EventItem_includes = Window_EventItem.prototype.includes;
  Window_EventItem.prototype.includes = function(item) {
    if (!_Window_EventItem_includes.call(this, item)) return false;
    var subCategory = $gameTemp.eventItemSubCategory();
    return !subCategory || item.meta.subCategory === subCategory;
  };

  var _Window_EventItem_onOk = Window_EventItem.prototype.onOk;
  Window_EventItem.prototype.onOk = function() {
    _Window_EventItem_onOk.call(this);
    this._helpWindow.close();
    $gameTemp.setEventItemSubCategory(null);
  };

  var _Window_EventItem_onCancel = Window_EventItem.prototype.onCancel;
  Window_EventItem.prototype.onCancel = function() {
    _Window_EventItem_onCancel.call(this);
    this._helpWindow.close();
    $gameTemp.setEventItemSubCategory(null);
  };

  Window_EventItem.prototype.needsNumber = function() {
    var itypeId = $gameMessage.itemChoiceItypeId();
    return (itypeId === 1 && TMPlugin.EventItemEx.ShowItemNumberItem) ||
           (itypeId === 2 && TMPlugin.EventItemEx.ShowItemNumberKey) ||
           (itypeId === 3 && TMPlugin.EventItemEx.ShowItemNumberA) ||
           (itypeId === 4 && TMPlugin.EventItemEx.ShowItemNumberB);
  };

  //-----------------------------------------------------------------------------
  // Window_Message
  //

  var _Window_Message_subWindows = Window_Message.prototype.subWindows;
  Window_Message.prototype.subWindows = function() {
    var subWindows = _Window_Message_subWindows.call(this);
    subWindows.push(this._helpWindow);
    return subWindows;
  };

  var _Window_Message_createSubWindows = Window_Message.prototype.createSubWindows;
  Window_Message.prototype.createSubWindows = function() {
    _Window_Message_createSubWindows.call(this);
    this._helpWindow = new Window_Help();
    this._helpWindow.openness = 0;
    this._itemWindow.setHelpWindow(this._helpWindow);
  };

})();